
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Ringo
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1") # hours worked by John
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Bill


    # Set objective function
    model.setObjective(9*x0 + 3*x1 + 1*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6*x0 + 7*x1 >= 64, "c0")
    model.addConstr(6*x0 + 19*x2 >= 37, "c1")
    model.addConstr(6*x0 + 7*x1 + 19*x2 >= 71, "c2")
    model.addConstr(8*x1 + 22*x2 >= 50, "c3")
    model.addConstr(8*x0 + 15*x1 >= 59, "c4")
    model.addConstr(8*x0 + 22*x2 >= 40, "c5")
    model.addConstr(8*x0 + 15*x1 + 22*x2 >= 40, "c6") # Redundant, implied by c3, c4, c5
    model.addConstr(14*x1 + 15*x2 >= 53, "c7")
    model.addConstr(11*x0 + 14*x1 + 15*x2 >= 53, "c8")
    model.addConstr(-8*x0 + 4*x2 >= 0, "c9")
    model.addConstr(7*x1 + 19*x2 <= 166, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
