
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by John
x2 = m.addVar(name="x2")  # hours worked by Bill

# Objective function
m.setObjective(9 * x0 + 3 * x1 + x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(6 * x0 + 7 * x1 >= 64)
m.addConstr(6 * x0 + 19 * x2 >= 37)
m.addConstr(6 * x0 + 7 * x1 + 19 * x2 >= 71)
m.addConstr(8 * x1 + 22 * x2 >= 50)
m.addConstr(8 * x0 + 15 * x1 >= 59)
m.addConstr(8 * x0 + 22 * x2 >= 40)
m.addConstr(8 * x0 + 15 * x1 + 22 * x2 >= 40)
m.addConstr(14 * x1 + 15 * x2 >= 53)
m.addConstr(11 * x0 + 14 * x1 + 15 * x2 >= 53)
m.addConstr(-8 * x0 + 4 * x2 >= 0)
m.addConstr(7 * x1 + 19 * x2 <= 166)

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("No solution found")
