
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    dale_hours = m.addVar(name="dale_hours")
    paul_hours = m.addVar(name="paul_hours")
    bobby_hours = m.addVar(name="bobby_hours")


    # Set objective function
    m.setObjective(2.43 * dale_hours + 3.2 * paul_hours + 3.04 * bobby_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(16 * dale_hours + 14 * paul_hours + 16 * bobby_hours >= 91, "dollar_cost_min")
    m.addConstr(15 * dale_hours + 10 * paul_hours >= 54, "productivity_dale_paul_min")
    m.addConstr(10 * paul_hours + 21 * bobby_hours >= 44, "productivity_paul_bobby_min")
    m.addConstr(16 * dale_hours + 16 * bobby_hours <= 166, "dollar_cost_dale_bobby_max")
    m.addConstr(14 * paul_hours + 16 * bobby_hours <= 119, "dollar_cost_paul_bobby_max")
    m.addConstr(16 * dale_hours + 14 * paul_hours + 16 * bobby_hours <= 132, "dollar_cost_total_max")
    m.addConstr(15 * dale_hours + 21 * bobby_hours <= 144, "productivity_dale_bobby_max")
    m.addConstr(15 * dale_hours + 10 * paul_hours <= 239, "productivity_dale_paul_max")
    m.addConstr(15 * dale_hours + 10 * paul_hours + 21 * bobby_hours <= 205, "productivity_total_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Dale Hours: %g' % dale_hours.x)
        print('Paul Hours: %g' % paul_hours.x)
        print('Bobby Hours: %g' % bobby_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
