
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='hours_worked_by_Dale', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name='hours_worked_by_Paul', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='hours_worked_by_Bobby', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(2.43*x0 + 3.2*x1 + 3.04*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(16*x0 + 14*x1 + 16*x2 >= 91)
    model.addConstr(15*x0 + 10*x1 >= 54)
    model.addConstr(10*x1 + 21*x2 >= 44)
    model.addConstr(16*x0 + 16*x2 <= 166)
    model.addConstr(14*x1 + 16*x2 <= 119)
    model.addConstr(16*x0 + 14*x1 + 16*x2 <= 132)
    model.addConstr(15*x0 + 10*x1 + 21*x2 <= 205)
    model.addConstr(15*x0 + 21*x2 <= 144)
    model.addConstr(15*x0 + 10*x1 <= 239)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Dale: {x0.varValue}')
        print(f'Hours worked by Paul: {x1.varValue}')
        print(f'Hours worked by Bobby: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
