
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fiber")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")


    # Set objective function
    m.setObjective(8.96*x0**2 + 5.67*x0 + 2.38*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 1*x1 >= 24, "c0")
    m.addConstr(9*x0**2 - 8*x1**2 >= 0, "c1")
    m.addConstr(4*x0**2 + 1*x1**2 <= 71, "c2")
    m.addConstr(4*x0**2 + 1*x1**2 >= 24, "c3")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('grams of fiber:', x0.x)
        print('milligrams of potassium:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

