
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="grams_of_fiber")
x2 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="milligrams_of_potassium")

# Set the objective function
m.setObjective(8.96*x1**2 + 5.67*x1 + 2.38*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1**2 + x2**2 >= 24, name="energy_stability_index_squared")
m.addConstr(4*x1 + x2 >= 24, name="total_energy_stability_index")
m.addConstr(9*x1**2 - 8*x2**2 >= 0, name="fiber_and_potassium_constraint")
m.addConstr(x1**2 + x2**2 <= 71, name="energy_stability_index_squared_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of fiber: {x1.x}")
    print(f"Milligrams of potassium: {x2.x}")
else:
    print("No optimal solution found.")
