
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(8.96 * x1**2 + 5.67 * x1 + 2.38 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 == 1, name="c1")
    model.addConstr(x2 == 1, name="c2")
    model.addConstr(16 * x1**2 + x2**2 >= 24, name="c3")
    model.addConstr(4 * x1 + x2 >= 24, name="c4")
    model.addConstr(9 * x1**2 - 8 * x2**2 >= 0, name="c5")
    model.addConstr(16 * x1**2 + x2**2 <= 71, name="c6")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
