
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
granola_bars = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
steaks = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")


# Set objective function
m.setObjective(1 * granola_bars + 9 * steaks, GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * granola_bars + 12 * steaks >= 9, "c0")
m.addConstr(9 * granola_bars - 8 * steaks >= 0, "c1")
m.addConstr(11 * granola_bars + 12 * steaks <= 24, "c2")
m.addConstr(11 * granola_bars + 12 * steaks <= 27, "healthiness_upper_bound")



# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('granola_bars:', granola_bars.x)
    print('steaks:', steaks.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status:', m.status)

