
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables - since the number of granola bars and steaks can be non-integer,
# we use continuous variable type
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")

# Set the objective function
m.setObjective(x1 + 9*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x1 + 12*x2 >= 9, "min_healthiness")
m.addConstr(9*x1 - 8*x2 >= 0, "health_steak_ratio")
m.addConstr(11*x1 + 12*x2 <= 24, "max_healthiness")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Granola bars: {x1.x}")
    print(f"Steaks: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
