
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="granola_bars", lb=0)  # granola bars
x2 = model.addVar(name="steaks", lb=0)     # steaks

# Set the objective function
model.setObjective(x1 + 9 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(11 * x1 + 12 * x2 >= 9, name="healthiness_rating_min")
model.addConstr(11 * x1 + 12 * x2 <= 24, name="healthiness_rating_max")
model.addConstr(9 * x1 - 8 * x2 >= 0, name="granola_steak_ratio")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Granola bars: {x1.varValue}")
    print(f"Steaks: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
