
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    john_hours = model.addVar(vtype=gp.GRB.INTEGER, name="john_hours")
    hank_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="hank_hours")

    # Set objective function
    model.setObjective(3.94 * john_hours + 7.71 * hank_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * john_hours + 3 * hank_hours >= 16, "productivity_min")
    model.addConstr(6 * john_hours + 8 * hank_hours >= 40, "organization_min")
    model.addConstr(8 * john_hours - 2 * hank_hours >= 0, "john_hank_relation")
    model.addConstr(15 * john_hours + 3 * hank_hours <= 87, "productivity_max")
    model.addConstr(6 * john_hours + 8 * hank_hours <= 87, "organization_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('John Hours: %g' % john_hours.x)
        print('Hank Hours: %g' % hank_hours.x)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

