
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_John")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Set the objective function
m.setObjective(3.94*x0 + 7.71*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x0 + 3*x1 >= 16, "productivity_rating")
m.addConstr(6*x0 + 8*x1 >= 40, "organization_score_min")
m.addConstr(8*x0 - 2*x1 >= 0, "constraint_1")
m.addConstr(15*x0 + 3*x1 <= 87, "productivity_rating_max")
m.addConstr(6*x0 + 8*x1 <= 100, "organization_score_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by John: {x0.x}")
    print(f"Hours worked by Hank: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
