
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_John", vtype=gurobi.GRB.INTEGER)  # Assuming x1 is integer
x2 = m.addVar(name="hours_worked_by_Hank")

# Set objective function
m.setObjective(3.94 * x1 + 7.71 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * x1 + 3 * x2 >= 16)
m.addConstr(6 * x1 + 8 * x2 >= 40)
m.addConstr(8 * x1 - 2 * x2 >= 0)
m.addConstr(15 * x1 + 3 * x2 <= 87)
m.addConstr(6 * x1 + 8 * x2 <= 87)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by John: {x1.varValue}")
    print(f"Hours worked by Hank: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
