
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_c = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    vitamin_b3 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b3")
    vitamin_b9 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b9")
    vitamin_d = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")


    # Set objective
    m.setObjective(3*vitamin_c*vitamin_b3 + 2*vitamin_b3**2 + 2*vitamin_b3*vitamin_d + 4*vitamin_c, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*vitamin_c <= 199, "c0")
    m.addConstr(11*vitamin_b3 <= 199, "c1")
    m.addConstr(6*vitamin_b9 <= 199, "c2")
    m.addConstr(10*vitamin_d <= 199, "c3")
    m.addConstr(6*vitamin_b9 + 10*vitamin_d >= 31, "c4")
    m.addConstr(11*vitamin_b3 + 6*vitamin_b9 >= 30, "c5")
    m.addConstr(8*vitamin_c**2 + 11*vitamin_b3**2 >= 46, "c6")
    m.addConstr(8*vitamin_c + 6*vitamin_b9 <= 74, "c7")
    m.addConstr(6*vitamin_b9 + 10*vitamin_d <= 115, "c8")
    m.addConstr(11*vitamin_b3 + 6*vitamin_b9 <= 79, "c9")
    m.addConstr(11*vitamin_b3 + 6*vitamin_b9 + 10*vitamin_d <= 192, "c10")
    m.addConstr(8*vitamin_c + 11*vitamin_b3 + 10*vitamin_d <= 124, "c11")
    m.addConstr(8*vitamin_c + 11*vitamin_b3 + 6*vitamin_b9 + 10*vitamin_d <= 124, "c12")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
