
import gurobi as gp

# Create a new model
m = gp.Model()

# Define variables
x1 = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="x1")  # fractional
x2 = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="x2", vtype=gp.GRB.INTEGER)  # integer
x3 = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="x3", vtype=gp.GRB.INTEGER)  # integer
x4 = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="x4", vtype=gp.GRB.INTEGER)  # integer

# Objective function
m.setObjective(3*x1*x2 + 2*x2**2 + 2*x2*x4 + 4*x1, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 == 1)
m.addConstr(x2 == 1)
m.addConstr(x3 == 1)
m.addConstr(x4 == 1)

# Other constraints
m.addConstr(6*x3 + 10*x4 >= 31)
m.addConstr(11*x2 + 6*x3 >= 30)
m.addConstr(8*x1 + 11*x2 >= 46)
m.addConstr(8*x1 + 6*x3 <= 74)
m.addConstr(6*x3 + 10*x4 <= 115)
m.addConstr(11*x2 + 6*x3 <= 79)
m.addConstr(11*x2 + 6*x3 + 10*x4 <= 192)
m.addConstr(8*x1 + 11*x2 + 10*x4 <= 124)
m.addConstr(8*x1 + 11*x2 + 6*x3 + 10*x4 <= 124)

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("No optimal solution found")
