
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("military_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="transportation_companies")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry_companies")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="military_intelligence_companies")

    # Set objective function
    m.setObjective(5*x0 + 4*x1 + 4*x2 + 9*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(22.57*x0 + 12.35*x2 >= 31)
    m.addConstr(22.57*x0 + 14.68*x3 >= 40)
    m.addConstr(22.57*x0 + 0.6*x1 + 14.68*x3 >= 44)
    m.addConstr(0.6*x1 + 12.35*x2 + 14.68*x3 >= 44)
    m.addConstr(22.57*x0 + 0.6*x1 + 14.68*x3 >= 60)
    m.addConstr(0.6*x1 + 12.35*x2 + 14.68*x3 >= 60)
    m.addConstr(22.57*x0 + 0.6*x1 + 12.35*x2 + 14.68*x3 >= 60)
    m.addConstr(16.17*x0 + 13.66*x2 >= 29)
    m.addConstr(16.17*x0 + 4.99*x3 >= 46)
    m.addConstr(23.31*x1 + 13.66*x2 >= 47)
    m.addConstr(16.17*x0 + 23.31*x1 + 13.66*x2 + 4.99*x3 >= 47)
    m.addConstr(8*x1 - x2 >= 0)
    m.addConstr(0.6*x1 + 12.35*x2 <= 199)
    m.addConstr(0.6*x1 + 12.35*x2 + 14.68*x3 <= 186)
    m.addConstr(16.17*x0 + 4.99*x3 <= 105)
    m.addConstr(23.31*x1 + 13.66*x2 <= 163)
    m.addConstr(16.17*x0 + 13.66*x2 <= 72)
    m.addConstr(16.17*x0 + 23.31*x1 <= 154)
    m.addConstr(23.31*x1 + 4.99*x3 <= 80)
    m.addConstr(23.31*x1 + 13.66*x2 + 4.99*x3 <= 137)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
