
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='CBRN_platoons', vtype='I')  # CBRN platoons
x2 = m.addVar(name='transportation_companies', vtype='I')  # transportation companies
x3 = m.addVar(name='light_infantry_companies', vtype='I')  # light infantry companies
x4 = m.addVar(name='military_intelligence_companies', vtype='I')  # military intelligence companies

# Define the objective function
m.setObjective(5 * x1 + 4 * x2 + 4 * x3 + 9 * x4, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(22.57 * x1 >= 22.57, name='fun_factor_CBRN')
m.addConstr(16.17 * x1 >= 16.17, name='fuel_demand_CBRN')
m.addConstr(0.6 * x2 >= 0.6, name='fun_factor_transportation')
m.addConstr(23.31 * x2 >= 23.31, name='fuel_demand_transportation')
m.addConstr(12.35 * x3 >= 12.35, name='fun_factor_light_infantry')
m.addConstr(13.66 * x3 >= 13.66, name='fuel_demand_light_infantry')
m.addConstr(14.68 * x4 >= 14.68, name='fun_factor_military_intelligence')
m.addConstr(4.99 * x4 >= 4.99, name='fuel_demand_military_intelligence')

m.addConstr(22.57 * x1 + 12.35 * x3 >= 31, name='fun_factor_CBRN_light_infantry')
m.addConstr(22.57 * x1 + 14.68 * x4 >= 40, name='fun_factor_CBRN_military_intelligence')
m.addConstr(22.57 * x1 + 0.6 * x2 + 14.68 * x4 >= 44, name='fun_factor_CBRN_transportation_military_intelligence')
m.addConstr(0.6 * x2 + 12.35 * x3 + 14.68 * x4 >= 44, name='fun_factor_transportation_light_infantry_military_intelligence')
m.addConstr(22.57 * x1 + 0.6 * x2 + 14.68 * x4 >= 60, name='fun_factor_CBRN_transportation_military_intelligence_corrected')
m.addConstr(0.6 * x2 + 12.35 * x3 + 14.68 * x4 >= 60, name='fun_factor_transportation_light_infantry_military_intelligence_corrected')
m.addConstr(22.57 * x1 + 0.6 * x2 + 12.35 * x3 + 14.68 * x4 >= 60, name='fun_factor_all')

m.addConstr(16.17 * x1 + 13.66 * x3 >= 29, name='fuel_demand_CBRN_light_infantry')
m.addConstr(16.17 * x1 + 4.99 * x4 >= 46, name='fuel_demand_CBRN_military_intelligence')
m.addConstr(23.31 * x2 + 13.66 * x3 >= 47, name='fuel_demand_transportation_light_infantry')
m.addConstr(16.17 * x1 + 23.31 * x2 + 13.66 * x3 + 4.99 * x4 >= 47, name='fuel_demand_all')

m.addConstr(8 * x2 - x3 >= 0, name='relationship_transportation_light_infantry')
m.addConstr(0.6 * x2 + 12.35 * x3 <= 199, name='fun_factor_limit_transportation_light_infantry')
m.addConstr(0.6 * x2 + 12.35 * x3 + 14.68 * x4 <= 186, name='fun_factor_limit_transportation_light_infantry_military_intelligence')
m.addConstr(16.17 * x1 + 4.99 * x4 <= 105, name='fuel_demand_limit_CBRN_military_intelligence')
m.addConstr(23.31 * x2 + 13.66 * x3 <= 163, name='fuel_demand_limit_transportation_light_infantry')
m.addConstr(16.17 * x1 + 13.66 * x3 <= 72, name='fuel_demand_limit_CBRN_light_infantry')
m.addConstr(16.17 * x1 + 23.31 * x2 <= 154, name='fuel_demand_limit_CBRN_transportation')
m.addConstr(23.31 * x2 + 4.99 * x4 <= 80, name='fuel_demand_limit_transportation_military_intelligence')
m.addConstr(23.31 * x2 + 13.66 * x3 + 4.99 * x4 <= 137, name='fuel_demand_limit_transportation_light_infantry_military_intelligence')

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('CBRN platoons: ', x1.varValue)
    print('transportation companies: ', x2.varValue)
    print('light infantry companies: ', x3.varValue)
    print('military intelligence companies: ', x4.varValue)
else:
    print('No optimal solution found')
