
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bananas = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
pasta = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_pasta")
potatoes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
hamburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")


# Set objective function
m.setObjective(8.09 * bananas + 5.1 * pasta + 8.86 * potatoes + 4.19 * hamburgers, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.31 * pasta + 1.51 * potatoes >= 67)
m.addConstr(3.93 * bananas + 1.57 * hamburgers >= 77)
m.addConstr(0.31 * pasta + 1.57 * hamburgers >= 63)
m.addConstr(1.51 * potatoes + 1.57 * hamburgers >= 32)
m.addConstr(3.93 * bananas + 0.31 * pasta >= 60)
m.addConstr(3.93 * bananas + 1.51 * potatoes + 1.57 * hamburgers >= 60)
m.addConstr(3.93 * bananas + 0.31 * pasta + 1.57 * hamburgers >= 60)
m.addConstr(3.93 * bananas + 1.51 * potatoes + 1.57 * hamburgers >= 68)
m.addConstr(3.93 * bananas + 0.31 * pasta + 1.57 * hamburgers >= 68)
m.addConstr(3.93 * bananas + 0.31 * pasta + 1.51 * potatoes + 1.57 * hamburgers >= 68)
m.addConstr(4.86 * pasta + 2.44 * potatoes >= 106)
m.addConstr(2.44 * potatoes + 1.43 * hamburgers >= 41)
m.addConstr(1.31 * bananas + 2.44 * potatoes >= 64)
m.addConstr(1.31 * bananas + 4.86 * pasta >= 46)
m.addConstr(1.31 * bananas + 1.43 * hamburgers >= 61)
m.addConstr(4.86 * pasta + 1.43 * hamburgers >= 102)
m.addConstr(1.31 * bananas + 4.86 * pasta + 2.44 * potatoes + 1.43 * hamburgers >= 102)
m.addConstr(-5 * pasta + 5 * hamburgers >= 0)
m.addConstr(2 * pasta - 7 * potatoes >= 0)
m.addConstr(-1 * potatoes + 4 * hamburgers >= 0)
m.addConstr(3.93 * bananas + 0.31 * pasta + 1.57 * hamburgers <= 212)
m.addConstr(3.93 * bananas + 0.31 * pasta + 1.51 * potatoes <= 188)
m.addConstr(4.86 * pasta + 1.43 * hamburgers <= 431)
m.addConstr(1.31 * bananas + 1.43 * hamburgers <= 113)
m.addConstr(1.31 * bananas + 4.86 * pasta <= 136)
m.addConstr(2.44 * potatoes + 1.43 * hamburgers <= 185)
m.addConstr(1.31 * bananas + 2.44 * potatoes <= 418)
m.addConstr(1.31 * bananas + 2.44 * potatoes + 1.43 * hamburgers <= 127)
m.addConstr(1.31 * bananas + 4.86 * pasta + 2.44 * potatoes <= 260)

# Resource Constraints
m.addConstr(3.93 * bananas + 0.31 * pasta + 1.51 * potatoes + 1.57 * hamburgers <= 328)
m.addConstr(1.31 * bananas + 4.86 * pasta + 2.44 * potatoes + 1.43 * hamburgers <= 437)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

