
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Maximize Organization Score")

    # Create variables
    george_hours = model.addVar(vtype=gp.GRB.INTEGER, name="george_hours")
    john_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="john_hours")
    dale_hours = model.addVar(vtype=gp.GRB.INTEGER, name="dale_hours")


    # Set objective function
    model.setObjective(4 * george_hours + 5 * john_hours + 8 * dale_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * george_hours + 10 * john_hours <= 104, "c0")
    model.addConstr(4 * george_hours + 10 * john_hours + 4 * dale_hours <= 104, "c1")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by George: {george_hours.x}")
        print(f"Hours worked by John: {john_hours.x}")
        print(f"Hours worked by Dale: {dale_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
