
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_John")
x3 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Dale")

# Set the objective function
m.setObjective(4*x1 + 5*x2 + 8*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 10*x2 <= 104, "organization_score_George_John")
m.addConstr(4*x1 + 10*x2 + 4*x3 <= 160, "total_organization_score")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by George: {x1.x}")
    print(f"Hours worked by John: {x2.x}")
    print(f"Hours worked by Dale: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
