
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.CONTINUOUS)  # hours worked by John
    x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # hours worked by Dale

    # Define the objective function
    model.setObjective(4 * x1 + 5 * x2 + 8 * x3, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(4 * x1 + 10 * x2 <= 104)
    model.addConstr(4 * x1 + 10 * x2 + 4 * x3 <= 160)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by George: ', x1.varValue)
        print('Hours worked by John: ', x2.varValue)
        print('Hours worked by Dale: ', x3.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
