
from gurobipy import *

# Create a new model
m = Model("Work_Scheduling")

# Define variables (assuming non-negativity and allowing for fractional hours)
x1, x2, x3, x4, x5, x6, x7 = m.addVars(7, lb=0, name=['Bobby', 'Bill', 'Laura', 'Ringo', 'Jean', 'Peggy', 'George'])

# Objective function: For demonstration purposes, minimize the sum of hours worked
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7, GRB.MINIMIZE)

# Add constraints
# Example constraint: Total work quality rating from hours worked by Bill and Jean has to be 50 at maximum.
m.addConstr(x2 + x5 <= 50, 'Bill_and_Jean_Max_50')
# Add all other constraints here using the addConstr method

# Solve the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.VarName}: {v.X}")
