
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    cornichons = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
    oranges = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oranges")
    chicken_drumsticks = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_drumsticks")

    # Set objective function
    obj = cornichons**2 + 2*cornichons*oranges + cornichons*chicken_drumsticks + 8*oranges**2 + 3*oranges*chicken_drumsticks + 6*chicken_drumsticks**2 + 5*cornichons + 7*oranges + 2*chicken_drumsticks
    m.setObjective(obj, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*cornichons + 9*oranges + 2*chicken_drumsticks <= 256, "c0")
    m.addConstr(cornichons + 25*oranges + 9*chicken_drumsticks <= 301, "c1")
    m.addConstr(21*cornichons + 26*oranges + 13*chicken_drumsticks <= 211, "c2")
    m.addConstr(cornichons**2 + oranges**2 + chicken_drumsticks**2 >= 51, "c3")
    m.addConstr(26*oranges + 13*chicken_drumsticks >= 27, "c4")
    m.addConstr(6*cornichons + 2*chicken_drumsticks <= 210, "c5")
    m.addConstr(9*oranges + 2*chicken_drumsticks <= 117, "c6")
    m.addConstr(6*cornichons + 9*oranges + 2*chicken_drumsticks <= 184, "c7")
    m.addConstr(cornichons + 25*oranges <= 133, "c8")
    m.addConstr(25*oranges**2 + 9*chicken_drumsticks**2 <= 128, "c9")
    m.addConstr(cornichons + 25*oranges + 9*chicken_drumsticks <= 128, "c10")
    m.addConstr(21*cornichons + 13*chicken_drumsticks <= 103, "c11")
    m.addConstr(26*oranges + 13*chicken_drumsticks <= 75, "c12")
    m.addConstr(21*cornichons**2 + 26*oranges**2 + 13*chicken_drumsticks**2 <= 174, "c13")
    m.addConstr(21*cornichons + 26*oranges + 13*chicken_drumsticks <= 174, "c14")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
