
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    cornichons = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="cornichons")
    oranges = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="oranges")
    chicken_drumsticks = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="chicken_drumsticks")

    # Objective function
    model.setObjective(1 * cornichons**2 + 2 * cornichons * oranges + 1 * cornichons * chicken_drumsticks + 
                      8 * oranges**2 + 3 * oranges * chicken_drumsticks + 6 * chicken_drumsticks**2 + 
                      5 * cornichons + 7 * oranges + 2 * chicken_drumsticks, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * cornichons + 9 * oranges + 2 * chicken_drumsticks <= 256)
    model.addConstr(cornichons + 25 * oranges + 9 * chicken_drumsticks <= 301)
    model.addConstr(21 * cornichons + 26 * oranges + 13 * chicken_drumsticks <= 211)
    model.addConstr(6 * cornichons**2 + 9 * oranges**2 + 2 * chicken_drumsticks**2 >= 51)
    model.addConstr(26 * oranges + 13 * chicken_drumsticks >= 27)
    model.addConstr(6 * cornichons + 2 * chicken_drumsticks <= 210)
    model.addConstr(9 * oranges + 2 * chicken_drumsticks <= 117)
    model.addConstr(6 * cornichons + 9 * oranges + 2 * chicken_drumsticks <= 184)
    model.addConstr(cornichons + 25 * oranges <= 133)
    model.addConstr(25 * oranges**2 + 9 * chicken_drumsticks**2 <= 128)
    model.addConstr(cornichons + 25 * oranges + 9 * chicken_drumsticks <= 128)
    model.addConstr(21 * cornichons + 13 * chicken_drumsticks <= 103)
    model.addConstr(26 * oranges + 13 * chicken_drumsticks <= 75)
    model.addConstr(441 * cornichons**2 + 676 * oranges**2 + 169 * chicken_drumsticks**2 <= 174)
    model.addConstr(21 * cornichons + 26 * oranges + 13 * chicken_drumsticks <= 174)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("cornichons: ", cornichons.varValue)
        print("oranges: ", oranges.varValue)
        print("chicken_drumsticks: ", chicken_drumsticks.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
