
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    protein = m.addVar(lb=0, name="protein")  # grams of protein
    vitamin_d = m.addVar(lb=0, name="vitamin_d")  # milligrams of vitamin D


    # Set objective function
    m.setObjective(6.74 * protein + 7.11 * vitamin_d, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11 * protein + 1 * vitamin_d >= 60, "immune_support_min")
    m.addConstr(12 * protein + 19 * vitamin_d >= 18, "digestive_support_min")
    m.addConstr(6 * protein + 6 * vitamin_d >= 18, "energy_stability_min")
    m.addConstr(10 * protein - 3 * vitamin_d >= 0, "protein_vitamin_d_ratio")
    m.addConstr(11 * protein + 1 * vitamin_d <= 87, "immune_support_max")
    m.addConstr(12 * protein + 19 * vitamin_d <= 53, "digestive_support_max")
    m.addConstr(6 * protein + 6 * vitamin_d <= 39, "energy_stability_max")



    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"  Grams of protein: {protein.x}")
        print(f"  Milligrams of vitamin D: {vitamin_d.x}")
        print(f"  Objective value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

