
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (no bounds specified for now)
x1 = m.addVar(name="grams_of_protein", lb=0)  # Assuming non-negativity
x2 = m.addVar(name="milligrams_of_vitamin_D", lb=0)  # Assuming non-negativity

# Objective function: Maximize
m.setObjective(6.74*x1 + 7.11*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(11*x1 + 1*x2 >= 60, "immune_support_min")
m.addConstr(11*x1 + 1*x2 <= 87, "immune_support_max")
m.addConstr(12*x1 + 19*x2 >= 18, "digestive_support_min")
m.addConstr(12*x1 + 19*x2 <= 53, "digestive_support_max")
m.addConstr(6*x1 + 6*x2 >= 18, "energy_stability_min")
m.addConstr(6*x1 + 6*x2 <= 39, "energy_stability_max")
m.addConstr(10*x1 - 3*x2 >= 0, "additional_constraint")

# Solve the model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of protein: {x1.x}")
    print(f"Milligrams of vitamin D: {x2.x}")
else:
    print("No optimal solution found.")
