
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="grams_of_protein", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="milligrams_of_vitamin_D", lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(6.74 * x1 + 7.11 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11 * x1 + x2 >= 60, name="immune_support_index")
    model.addConstr(12 * x1 + 19 * x2 >= 18, name="digestive_support_index")
    model.addConstr(6 * x1 + 6 * x2 >= 18, name="energy_stability_index")
    model.addConstr(10 * x1 - 3 * x2 >= 0, name="protein_vitamin_D_ratio")
    model.addConstr(11 * x1 + x2 <= 87, name="immune_support_index_upper_bound")
    model.addConstr(12 * x1 + 19 * x2 <= 53, name="digestive_support_index_upper_bound")
    model.addConstr(6 * x1 + 6 * x2 <= 39, name="energy_stability_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of protein: {x1.varValue}")
        print(f"Milligrams of vitamin D: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
