
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Paul", "Hank", "Bobby", "John", "Dale", "George"])


# Set objective function
m.setObjective(4*x[0] + 6*x[1] + 6*x[2] + 3*x[3] + 9*x[4] + 6*x[5], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x[1] + 4*x[5] >= 23)
m.addConstr(18*x[2] + 4*x[5] >= 19)
m.addConstr(18*x[2] + 6*x[4] >= 34)
m.addConstr(14*x[0] + 6*x[4] >= 32)
m.addConstr(1*x[3] + 4*x[5] >= 45)
m.addConstr(1*x[1] + 6*x[4] + 4*x[5] >= 28)
m.addConstr(1*x[1] + 1*x[3] + 4*x[5] >= 28)
m.addConstr(18*x[2] + 1*x[3] + 4*x[5] >= 28)
m.addConstr(1*x[1] + 18*x[2] + 1*x[3] >= 28)
m.addConstr(1*x[1] + 18*x[2] + 4*x[5] >= 28)
m.addConstr(1*x[1] + 6*x[4] + 4*x[5] >= 33)
m.addConstr(1*x[1] + 1*x[3] + 4*x[5] >= 33)
m.addConstr(18*x[2] + 1*x[3] + 4*x[5] >= 33)
m.addConstr(1*x[1] + 18*x[2] + 1*x[3] >= 33)
m.addConstr(1*x[1] + 18*x[2] + 4*x[5] >= 33)
m.addConstr(1*x[1] + 6*x[4] + 4*x[5] >= 25)
m.addConstr(1*x[1] + 1*x[3] + 4*x[5] >= 25)
m.addConstr(18*x[2] + 1*x[3] + 4*x[5] >= 25)
m.addConstr(1*x[1] + 18*x[2] + 1*x[3] >= 25)
m.addConstr(1*x[1] + 18*x[2] + 4*x[5] >= 25)
m.addConstr(1*x[1] + 6*x[4] + 4*x[5] >= 37)
m.addConstr(1*x[1] + 1*x[3] + 4*x[5] >= 37)
m.addConstr(18*x[2] + 1*x[3] + 4*x[5] >= 37)
m.addConstr(1*x[1] + 18*x[2] + 1*x[3] >= 37)
m.addConstr(1*x[1] + 18*x[2] + 4*x[5] >= 37)
m.addConstr(1*x[1] + 6*x[4] + 4*x[5] >= 45)
m.addConstr(1*x[1] + 1*x[3] + 4*x[5] >= 45)
m.addConstr(18*x[2] + 1*x[3] + 4*x[5] >= 45)
m.addConstr(1*x[1] + 18*x[2] + 1*x[3] >= 45)
m.addConstr(1*x[1] + 18*x[2] + 4*x[5] >= 45)
m.addConstr(1*x[3] + 4*x[5] <= 228)
m.addConstr(14*x[0] + 1*x[1] <= 258)
m.addConstr(6*x[4] + 4*x[5] <= 70)
m.addConstr(1*x[1] + 18*x[2] <= 166)
m.addConstr(14*x[0] + 1*x[3] <= 93)
m.addConstr(14*x[0] + 6*x[4] <= 77)
m.addConstr(14*x[0] + 4*x[5] <= 128)
m.addConstr(14*x[0] + 1*x[1] + 18*x[2] + 1*x[3] + 6*x[4] + 4*x[5] <= 128)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

