
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Paul", lb=0)
x2 = m.addVar(name="hours_worked_by_Hank", lb=0)
x3 = m.addVar(name="hours_worked_by_Bobby", lb=0)
x4 = m.addVar(name="hours_worked_by_John", lb=0)
x5 = m.addVar(name="hours_worked_by_Dale", lb=0)
x6 = m.addVar(name="hours_worked_by_George", lb=0)

# Define the objective function
m.setObjective(4*x1 + 6*x2 + 6*x3 + 3*x4 + 9*x5 + 6*x6, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 <= 275)
m.addConstr(1*x2 <= 275)
m.addConstr(18*x3 <= 275)
m.addConstr(1*x4 <= 275)
m.addConstr(6*x5 <= 275)
m.addConstr(4*x6 <= 275)
m.addConstr(1*x2 + 4*x6 >= 23)
m.addConstr(18*x3 + 4*x6 >= 19)
m.addConstr(18*x3 + 6*x5 >= 34)
m.addConstr(14*x1 + 6*x5 >= 32)
m.addConstr(1*x4 + 4*x6 >= 45)
m.addConstr(1*x2 + 6*x5 + 4*x6 >= 28)
m.addConstr(1*x2 + 1*x4 + 4*x6 >= 28)
m.addConstr(18*x3 + 1*x4 + 4*x6 >= 28)
m.addConstr(1*x2 + 18*x3 + 4*x6 >= 28)
m.addConstr(1*x2 + 6*x5 + 4*x6 >= 33)
m.addConstr(1*x2 + 1*x4 + 4*x6 >= 33)
m.addConstr(18*x3 + 1*x4 + 4*x6 >= 33)
m.addConstr(1*x2 + 18*x3 + 1*x4 >= 33)
m.addConstr(1*x2 + 18*x3 + 4*x6 >= 33)
m.addConstr(1*x2 + 6*x5 + 4*x6 >= 25)
m.addConstr(1*x2 + 1*x4 + 4*x6 >= 25)
m.addConstr(18*x3 + 1*x4 + 4*x6 >= 25)
m.addConstr(1*x2 + 18*x3 + 1*x4 >= 25)
m.addConstr(1*x2 + 18*x3 + 4*x6 >= 25)
m.addConstr(1*x2 + 6*x5 + 4*x6 >= 37)
m.addConstr(1*x2 + 1*x4 + 4*x6 >= 37)
m.addConstr(18*x3 + 1*x4 + 4*x6 >= 37)
m.addConstr(1*x2 + 18*x3 + 1*x4 >= 37)
m.addConstr(1*x2 + 18*x3 + 4*x6 >= 37)
m.addConstr(1*x2 + 6*x5 + 4*x6 >= 45)
m.addConstr(1*x2 + 1*x4 + 4*x6 >= 45)
m.addConstr(18*x3 + 1*x4 + 4*x6 >= 45)
m.addConstr(1*x2 + 18*x3 + 1*x4 >= 45)
m.addConstr(1*x2 + 18*x3 + 4*x6 >= 45)
m.addConstr(1*x4 + 4*x6 <= 228)
m.addConstr(14*x1 + 1*x2 <= 258)
m.addConstr(6*x5 + 4*x6 <= 70)
m.addConstr(1*x2 + 18*x3 <= 166)
m.addConstr(14*x1 + 1*x4 <= 93)
m.addConstr(14*x1 + 6*x5 <= 77)
m.addConstr(14*x1 + 4*x6 <= 128)
m.addConstr(14*x1 + 1*x2 + 18*x3 + 1*x4 + 6*x5 + 4*x6 <= 128)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by Bobby: ", x3.varValue)
    print("Hours worked by John: ", x4.varValue)
    print("Hours worked by Dale: ", x5.varValue)
    print("Hours worked by George: ", x6.varValue)
else:
    print("The model is infeasible")
