
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")  # hours worked by John
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")  # hours worked by Bobby
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x2")  # hours worked by Peggy
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")  # hours worked by Hank
x4 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x4")  # hours worked by Mary


# Set objective function
m.setObjective(6*x0**2 + 6*x0*x1 + x0*x2 + 8*x0*x4 + 4*x1*x2 + 3*x1*x3 + 9*x1*x4 + 2*x2**2 + 3*x2*x3 + 9*x3**2 + 8*x3*x4 + 4*x4**2 + 3*x0 + 8*x1 + 6*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x2 + 2*x4 >= 37)
m.addConstr(6*x0 + 17*x2 >= 56)
m.addConstr(3*x1**2 + 8*x3**2 >= 36)
m.addConstr(3*x1 + 2*x4 >= 62)
m.addConstr(6*x0 + 3*x1 >= 58)
m.addConstr(6*x0**2 + 2*x4**2 >= 40)
m.addConstr(3*x1 + 17*x2 >= 35)
m.addConstr(6*x0 + 17*x2 + 2*x4 >= 38)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

