
import gurobi

# Define variables
m = gurobi.Model()
x0 = m.addVar(lb=0, name='x0')  # hours worked by John
x1 = m.addVar(lb=0, name='x1')  # hours worked by Bobby
x2 = m.addVar(lb=0, name='x2')  # hours worked by Peggy
x3 = m.addVar(lb=0, name='x3')  # hours worked by Hank
x4 = m.addVar(lb=0, name='x4')  # hours worked by Mary

# Objective function
m.setObjective(6*x0**2 + 6*x0*x1 + x0*x2 + 8*x0*x4 + 4*x1*x2 + 3*x1*x3 + 9*x1*x4 + 2*x2**2 + 3*x2*x3 + 9*x3**2 + 8*x3*x4 + 4*x4**2 + 3*x0 + 8*x1 + 6*x4, gurobi.GRB.MAXIMIZE)

# Constraints
# ... too many constraints to list here, see step 3 for full list

# Add constraints
# for constraint in constraints:
#     m.addConstr(gurobi.quicksum([eval(term) for term in constraint.split('+')]), gurobi.GRB.EQUAL, rhs)

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: %g' % m.objVal)
    print('x0: %g' % x0.varValue)
    print('x1: %g' % x1.varValue)
    print('x2: %g' % x2.varValue)
    print('x3: %g' % x3.varValue)
    print('x4: %g' % x4.varValue)
else:
    print('No solution found')
