
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="hours worked by Ringo")
    x1 = m.addVar(name="hours worked by Dale")


    # Set objective function
    m.setObjective(7.11*x0**2 + 7.12*x1**2 + 7.13*x0, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(20*x0**2 + 18*x1**2 >= 53, "c1")
    m.addConstr(20*x0 + 18*x1 >= 53, "c2")
    m.addConstr(10*x0**2 + 16*x1**2 >= 40, "c3")
    m.addConstr(10*x0 + 16*x1 >= 40, "c4")
    m.addConstr(9*x0 - 6*x1 >= 0, "c5")
    m.addConstr(20*x0 + 18*x1 <= 94, "c6")
    m.addConstr(10*x0 + 16*x1 <= 116, "c7")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model could not be solved to optimality.")

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

