
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")

# Set the objective function
m.setObjective(7.11*x1**2 + 7.12*x2**2 + 7.13*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 18*x2 >= 53, name="Combined_Likelihood_Lower_Bound")
m.addConstr(10*x1 + 16*x2 >= 40, name="Combined_Organization_Score_Lower_Bound")
m.addConstr(9*x1 - 6*x2 >= 0, name="Score_and_Hours_Constraint")
m.addConstr(20*x1 + 18*x2 <= 94, name="Combined_Likelihood_Upper_Bound")
m.addConstr(10*x1 + 16*x2 <= 116, name="Combined_Organization_Score_Upper_Bound")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Hours worked by Dale: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
