
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Ringo", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Dale", lb=0)

    # Define the objective function
    model.setObjective(7.11 * x1**2 + 7.12 * x2**2 + 7.13 * x1, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(20 * x1 + 18 * x2 >= 53, name="likelihood_to_quit_index")
    model.addConstr(20 * x1**2 + 18 * x2**2 >= 53, name="combined_likelihood_to_quit_index_squared")
    model.addConstr(10 * x1 + 16 * x2 >= 40, name="organization_score")
    model.addConstr(10 * x1**2 + 16 * x2**2 >= 40, name="combined_organization_score_squared")
    model.addConstr(9 * x1 - 6 * x2 >= 0, name="ringo_dale_hours_constraint")
    model.addConstr(20 * x1 + 18 * x2 <= 94, name="max_likelihood_to_quit_index")
    model.addConstr(10 * x1 + 16 * x2 <= 116, name="max_organization_score")

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Ringo: {x1.varValue}")
        print(f"Hours worked by Dale: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
