
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Work_Hours")

# Create variables
laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")
george = model.addVar(vtype=gp.GRB.INTEGER, name="george")
bobby = model.addVar(vtype=gp.GRB.INTEGER, name="bobby")
jean = model.addVar(vtype=gp.GRB.INTEGER, name="jean")
ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")


# Set objective function
model.setObjective(1.78 * laura + 3.84 * george + 5.67 * bobby + 7.82 * jean + 4.85 * ringo, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * laura + 11 * ringo >= 34)
model.addConstr(6 * laura + 6 * george >= 26)
model.addConstr(7 * jean + 11 * ringo >= 36)
model.addConstr(6 * laura + 2 * bobby >= 24)
model.addConstr(6 * george + 7 * jean >= 20)
model.addConstr(6 * laura + 6 * george + 2 * bobby >= 37)
model.addConstr(6 * george + 2 * bobby + 11 * ringo >= 37)
model.addConstr(6 * george + 7 * jean + 11 * ringo >= 37)
model.addConstr(6 * george + 4 * bobby >= 14)
model.addConstr(6 * laura + 10 * jean >= 27)
model.addConstr(6 * laura + 1 * george >= 16)
model.addConstr(1 * george + 2 * ringo >= 27)
model.addConstr(4 * bobby + 2 * ringo >= 22)
model.addConstr(10 * jean + 2 * ringo >= 34)
model.addConstr(6 * laura + 10 * jean + 2 * ringo >= 35)
model.addConstr(4 * bobby + 10 * jean + 2 * ringo >= 35)
model.addConstr(6 * laura + 4 * bobby + 2 * ringo >= 35)
model.addConstr(1 * george + 4 * bobby + 2 * ringo >= 35)
model.addConstr(6 * laura + 1 * george + 2 * ringo >= 35)
model.addConstr(6 * laura + 1 * george + 10 * jean >= 35)
model.addConstr(6 * laura + 6 * george + 7 * jean <= 79)
model.addConstr(6 * george + 2 * bobby + 7 * jean <= 200)
model.addConstr(6 * laura + 2 * bobby + 11 * ringo <= 180)
model.addConstr(2 * bobby + 7 * jean + 11 * ringo <= 46)
model.addConstr(6 * george + 7 * jean + 11 * ringo <= 178)
model.addConstr(6 * george + 2 * bobby + 11 * ringo <= 140)
model.addConstr(6 * laura + 6 * george + 11 * ringo <= 102)
model.addConstr(6 * laura + 7 * jean + 11 * ringo <= 128)
model.addConstr(6 * laura + 6 * george + 2 * bobby + 7 * jean + 11 * ringo >= 37)
model.addConstr(9 * laura - 8 * ringo >= 0)
model.addConstr(-2 * laura + 5 * jean >= 0)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

