
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
oreos = model.addVar(vtype=GRB.INTEGER, name="oreos")
chicken_breasts = model.addVar(vtype=GRB.CONTINUOUS, name="chicken_breasts")
potatoes = model.addVar(vtype=GRB.CONTINUOUS, name="potatoes")
bananas = model.addVar(vtype=GRB.CONTINUOUS, name="bananas")
apples = model.addVar(vtype=GRB.CONTINUOUS, name="apples")


# Set objective function
model.setObjective(6*oreos + 4*chicken_breasts + 7*potatoes + 6*bananas + 7*apples, GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*oreos + apples >= 34)
model.addConstr(10*oreos + 4*potatoes >= 29)
model.addConstr(4*potatoes + 9*bananas >= 15)
model.addConstr(10*oreos + chicken_breasts >= 39)
model.addConstr(10*oreos + 9*bananas >= 31)
model.addConstr(chicken_breasts + 9*bananas >= 36)

# ... (rest of the fiber constraints from the JSON)

model.addConstr(6*oreos + 4*potatoes >= 14)
model.addConstr(6*oreos + 3*apples >= 16)

# ... (rest of the iron constraints from the JSON)


model.addConstr(10*oreos + chicken_breasts <= 170)
model.addConstr(chicken_breasts + 9*bananas <= 83)
model.addConstr(10*oreos + 9*bananas <= 116)
model.addConstr(4*potatoes + apples <= 158)
model.addConstr(chicken_breasts + apples <= 48)

# ... (rest of the upper bound constraints from the JSON)

model.addConstr(10 * oreos + 1 * apples <= 228)
model.addConstr(6 * oreos + 5 * chicken_breasts + 4 * potatoes + 2 * bananas + 3 * apples <= 137)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Oreos:', oreos.x)
    print('Chicken Breasts:', chicken_breasts.x)
    print('Potatoes:', potatoes.x)
    print('Bananas:', bananas.x)
    print('Apples:', apples.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

