
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="oreos", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="chicken breasts")
x2 = m.addVar(name="potatoes")
x3 = m.addVar(name="bananas")
x4 = m.addVar(name="apples")

# Objective function
m.setObjective(6*x0 + 4*x1 + 7*x2 + 6*x3 + 7*x4, gurobi.GRB.MAXIMIZE)

# Constraints
# Fiber constraints
m.addConstr(10*x0 + x1 + 4*x2 + 9*x3 + x4 <= 228)
m.addConstr(10*x0 + x4 >= 34)
m.addConstr(10*x0 + 4*x2 >= 29)
m.addConstr(4*x2 + 9*x3 >= 15)
m.addConstr(10*x0 + x1 >= 39)
m.addConstr(10*x0 + 9*x3 >= 31)
m.addConstr(x1 + 9*x3 >= 36)
m.addConstr(10*x0 + 4*x2 + x4 >= 36)
m.addConstr(x1 + 4*x2 + 9*x3 >= 36)
m.addConstr(x1 + 9*x3 + x4 >= 36)
m.addConstr(10*x0 + x1 + 9*x3 >= 36)
m.addConstr(10*x0 + 9*x3 + x4 >= 36)
m.addConstr(10*x0 + 4*x2 + 9*x3 >= 36)
m.addConstr(10*x0 + 4*x2 + x4 >= 38)
m.addConstr(x1 + 4*x2 + 9*x3 >= 38)
m.addConstr(x1 + 9*x3 + x4 >= 38)
m.addConstr(10*x0 + x1 + 9*x3 >= 38)
m.addConstr(10*x0 + 9*x3 + x4 >= 38)

# Iron constraints
m.addConstr(6*x0 + 5*x1 + 4*x2 + 2*x3 + 3*x4 <= 137)
m.addConstr(6*x0 + 4*x2 >= 14)
m.addConstr(6*x0 + 3*x4 >= 16)
m.addConstr(6*x0 + 5*x1 + 2*x3 >= 26)

# Bounds
m.addConstr(10*x0 + x1 <= 170)
m.addConstr(x1 + 9*x3 <= 83)
m.addConstr(10*x0 + 9*x3 <= 116)
m.addConstr(4*x2 + x4 <= 158)

# Optimize
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oreos: ", x0.varValue)
    print("Chicken breasts: ", x1.varValue)
    print("Potatoes: ", x2.varValue)
    print("Bananas: ", x3.varValue)
    print("Apples: ", x4.varValue)
else:
    print("No solution found")
