
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_d")
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")


# Set objective function
m.setObjective(2.9 * vitamin_b6 + 5.87 * vitamin_d + 4.47 * iron + 1.68 * vitamin_e, gp.GRB.MINIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'upper_bound': 186, 'x0': 24, 'x1': 20, 'x2': 24, 'x3': 12},
    'r1': {'upper_bound': 737, 'x0': 7, 'x1': 10, 'x2': 17, 'x3': 3},
    'r2': {'upper_bound': 686, 'x0': 14, 'x1': 26, 'x2': 26, 'x3': 8},
    'r3': {'upper_bound': 480, 'x0': 17, 'x1': 5, 'x2': 2, 'x3': 3},
    'r4': {'upper_bound': 292, 'x0': 20, 'x1': 29, 'x2': 27, 'x3': 24}
}

for r, data in resource_constraints.items():
    m.addConstr(data['x0'] * vitamin_b6 <= data['upper_bound'])
    m.addConstr(data['x1'] * vitamin_d <= data['upper_bound'])
    m.addConstr(data['x2'] * iron <= data['upper_bound'])
    m.addConstr(data['x3'] * vitamin_e <= data['upper_bound'])


m.addConstr(20 * vitamin_d + 12 * vitamin_e >= 43)
m.addConstr(24 * vitamin_b6 + 12 * vitamin_e >= 15)
m.addConstr(20 * vitamin_d + 24 * iron >= 35)
m.addConstr(24 * vitamin_b6 + 24 * iron >= 22)
# ... (rest of the constraints as in the JSON, replacing variable names)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_b6:', vitamin_b6.x)
    print('vitamin_d:', vitamin_d.x)
    print('iron:', iron.x)
    print('vitamin_e:', vitamin_e.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

