
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="kale_salads")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")


    # Set objective function
    m.setObjective(8*x0 + 8*x1 + 1*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(19*x1 + 11*x2 >= 33, "c0")
    m.addConstr(2*x0 + 19*x1 >= 26, "c1")
    m.addConstr(2*x0 + 11*x2 >= 21, "c2")
    m.addConstr(2*x0 + 19*x1 + 11*x2 >= 21, "c3")
    m.addConstr(16*x0 + 2*x1 >= 32, "c4")
    m.addConstr(2*x1 + 6*x2 >= 42, "c5")
    m.addConstr(16*x0 + 2*x1 + 6*x2 >= 42, "c6")
    m.addConstr(6*x0 + 3*x2 >= 45, "c7")
    m.addConstr(6*x0 + 14*x1 >= 25, "c8")
    m.addConstr(14*x1 + 3*x2 >= 46, "c9")
    m.addConstr(6*x0 + 14*x1 + 3*x2 >= 46, "c10")
    m.addConstr(1*x0 - 7*x1 >= 0, "c11")
    m.addConstr(19*x1 + 11*x2 <= 104, "c12")
    m.addConstr(2*x0 + 11*x2 <= 89, "c13")
    m.addConstr(16*x0 + 6*x2 <= 195, "c14")
    m.addConstr(2*x1 + 6*x2 <= 146, "c15")
    m.addConstr(6*x0 + 14*x1 <= 194, "c16")
    m.addConstr(6*x0 + 14*x1 + 3*x2 <= 128, "c17")

    # Resource Constraints
    m.addConstr(2*x0 <= 117, "r0")
    m.addConstr(16*x0 <= 247, "r1")
    m.addConstr(6*x0 <= 197, "r2")
    m.addConstr(19*x1 <= 117, "r3")
    m.addConstr(2*x1 <= 247, "r4")
    m.addConstr(14*x1 <= 197, "r5")
    m.addConstr(11*x2 <= 117, "r6")
    m.addConstr(6*x2 <= 247, "r7")
    m.addConstr(3*x2 <= 197, "r8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
