
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="chicken thighs", lb=0)
x1 = model.addVar(name="kale salads", lb=0)
x2 = model.addVar(name="apple pies", lb=0)

# Set the objective function
model.setObjective(8*x0 + 8*x1 + x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(19*x1 + 11*x2 >= 33)
model.addConstr(2*x0 + 19*x1 >= 26)
model.addConstr(2*x0 + 11*x2 >= 21)
model.addConstr(2*x0 + 19*x1 + 11*x2 >= 21)
model.addConstr(16*x0 + 2*x1 >= 32)
model.addConstr(2*x1 + 6*x2 >= 42)
model.addConstr(16*x0 + 2*x1 + 6*x2 >= 42)
model.addConstr(6*x0 + 3*x2 >= 45)
model.addConstr(6*x0 + 14*x1 >= 25)
model.addConstr(14*x1 + 3*x2 >= 46)
model.addConstr(6*x0 + 14*x1 + 3*x2 >= 46)
model.addConstr(x0 - 7*x1 >= 0)
model.addConstr(19*x1 + 11*x2 <= 104)
model.addConstr(2*x0 + 11*x2 <= 89)
model.addConstr(16*x0 + 6*x2 <= 195)
model.addConstr(2*x1 + 6*x2 <= 146)
model.addConstr(6*x0 + 14*x1 <= 194)
model.addConstr(6*x0 + 14*x1 + 3*x2 <= 128)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Chicken thighs: ", x0.x)
    print("Kale salads: ", x1.x)
    print("Apple pies: ", x2.x)
else:
    print("The model is infeasible")
