
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="candles")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper_rolls")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")


    # Set objective function
    m.setObjective(1*x0 + 4*x1 + 7*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(27*x0 + 22*x2 >= 73, "c1")
    m.addConstr(27*x0 + 24*x1 + 22*x2 >= 73, "c2")
    m.addConstr(9*x0 + 13*x1 >= 132, "c3")
    m.addConstr(9*x0 + 31*x2 >= 138, "c4")
    m.addConstr(9*x0 + 13*x1 + 31*x2 >= 138, "c5")
    m.addConstr(-2*x1 + 2*x2 >= 0, "c6")
    m.addConstr(27*x0 + 22*x2 <= 191, "c7")
    m.addConstr(24*x1 + 22*x2 <= 301, "c8")
    m.addConstr(27*x0 + 24*x1 + 22*x2 <= 202, "c9")

    # Resource constraints
    m.addConstr(x0 <= 322, "c10")
    m.addConstr(x1 <= 322, "c11")
    m.addConstr(x2 <= 322, "c12")
    m.addConstr(9*x0 + 13*x1 + 31*x2 <= 434, "c13")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Other optimization status code:', m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
