
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="candles", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="toilet paper rolls", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(1*x0 + 4*x1 + 7*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(27*x0 + 22*x2 >= 73)
    model.addConstr(27*x0 + 24*x1 + 22*x2 >= 73)
    model.addConstr(9*x0 + 13*x1 >= 132)
    model.addConstr(9*x0 + 31*x2 >= 138)
    model.addConstr(9*x0 + 13*x1 + 31*x2 >= 138)
    model.addConstr(-2*x1 + 2*x2 >= 0)
    model.addConstr(27*x0 + 22*x2 <= 191)
    model.addConstr(24*x1 + 22*x2 <= 301)
    model.addConstr(27*x0 + 24*x1 + 22*x2 <= 202)
    model.addConstr(27*x0 <= 322)
    model.addConstr(24*x1 <= 322)
    model.addConstr(22*x2 <= 322)
    model.addConstr(9*x0 + 13*x1 + 31*x2 <= 434)

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Candles: ", x0.varValue)
        print("Toilet paper rolls: ", x1.varValue)
        print("Diapers: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
