
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    bagged_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
    ravioli = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")


    # Set objective function
    m.setObjective(7 * bagged_salads + 9 * ravioli, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14 * bagged_salads + 12 * ravioli >= 45, "c1")
    m.addConstr(14 * bagged_salads + 4 * ravioli >= 57, "c2")
    m.addConstr(-10 * bagged_salads + 3 * ravioli >= 0, "c3")
    m.addConstr(14 * bagged_salads + 12 * ravioli <= 101, "c4")
    m.addConstr(14 * bagged_salads + 4 * ravioli <= 106, "c5")

    # Resource Constraints
    m.addConstr(14 * bagged_salads <= 107, "sourness_bagged_salads")
    m.addConstr(12 * ravioli <= 107, "sourness_ravioli")
    m.addConstr(14 * bagged_salads <= 174, "fat_bagged_salads")
    m.addConstr(4 * ravioli <= 174, "fat_ravioli")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('bagged_salads: %g' % bagged_salads.x)
        print('ravioli: %g' % ravioli.x)
    elif m.status == GRB.INFEASIBLE:
        print('Problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
