
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables to the model
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")

# Set the objective function
model.setObjective(7*x1 + 9*x2, GRB.MINIMIZE)

# Add constraints to the model
model.addConstr(14*x1 + 12*x2 >= 45, "min_sourness")
model.addConstr(14*x1 + 4*x2 >= 57, "min_fat")
model.addConstr(-10*x1 + 3*x2 >= 0, "mixed_constraint")
model.addConstr(14*x1 + 12*x2 <= 101, "max_sourness")
model.addConstr(14*x1 + 4*x2 <= 106, "max_fat")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found")
