
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="bagged_salads", lb=0)  # bagged salads
    x2 = model.addVar(name="ravioli", lb=0)     # ravioli

    # Objective function
    model.setObjective(7 * x1 + 9 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14 * x1 + 12 * x2 >= 45, name="sourness_index_min")
    model.addConstr(14 * x1 + 12 * x2 <= 101, name="sourness_index_max")
    model.addConstr(14 * x1 + 4 * x2 >= 57, name="fat_min")
    model.addConstr(14 * x1 + 4 * x2 <= 106, name="fat_max")
    model.addConstr(-10 * x1 + 3 * x2 >= 0, name="linear_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bagged Salads: {x1.varValue}")
        print(f"Ravioli: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
