
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Laura
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Bill
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Hank
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # hours worked by Paul


    # Set objective function
    m.setObjective(7*x0 + 8*x1 + 1*x2 + 3*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(26*x0 + 12*x2 >= 70)
    m.addConstr(23*x1 + 12*x2 >= 76)
    m.addConstr(26*x0 + 23*x1 >= 70)
    m.addConstr(26*x0 + 23*x1 + 12*x2 + 13*x3 >= 70)
    m.addConstr(8*x2 + 19*x3 >= 31)
    m.addConstr(9*x0 + 8*x2 >= 28)
    m.addConstr(9*x0 + 26*x1 >= 44)
    m.addConstr(9*x0 + 26*x1 + 19*x3 >= 28)
    m.addConstr(9*x0 + 26*x1 + 8*x2 + 19*x3 >= 28)
    m.addConstr(-5*x1 + x3 >= 0)
    m.addConstr(-7*x1 + 2*x2 >= 0)
    m.addConstr(6*x0 - 2*x1 >= 0)
    m.addConstr(26*x0 + 23*x1 <= 190)
    m.addConstr(23*x1 + 13*x3 <= 272)
    m.addConstr(12*x2 + 13*x3 <= 119)
    m.addConstr(26*x0 + 13*x3 <= 108)
    m.addConstr(9*x0 + 26*x1 + 19*x3 <= 168)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
