
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Laura
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bill
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Hank
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Paul

    # Define the objective function
    model.setObjective(7 * x0 + 8 * x1 + 1 * x2 + 3 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(26 * x0 <= 343)
    model.addConstr(9 * x0 <= 184)
    model.addConstr(23 * x1 <= 343)
    model.addConstr(26 * x1 <= 184)
    model.addConstr(12 * x2 <= 343)
    model.addConstr(8 * x2 <= 184)
    model.addConstr(13 * x3 <= 343)
    model.addConstr(19 * x3 <= 184)
    model.addConstr(26 * x0 + 12 * x2 >= 70)
    model.addConstr(23 * x1 + 12 * x2 >= 76)
    model.addConstr(26 * x0 + 23 * x1 >= 70)
    model.addConstr(26 * x0 + 23 * x1 + 12 * x2 + 13 * x3 >= 70)
    model.addConstr(8 * x2 + 19 * x3 >= 31)
    model.addConstr(9 * x0 + 8 * x2 >= 28)
    model.addConstr(9 * x0 + 26 * x1 >= 44)
    model.addConstr(9 * x0 + 26 * x1 + 19 * x3 >= 28)
    model.addConstr(9 * x0 + 26 * x1 + 8 * x2 + 19 * x3 >= 28)
    model.addConstr(-5 * x1 + x3 >= 0)
    model.addConstr(-7 * x1 + 2 * x2 >= 0)
    model.addConstr(6 * x0 - 2 * x1 >= 0)
    model.addConstr(26 * x0 + 23 * x1 <= 190)
    model.addConstr(23 * x1 + 13 * x3 <= 272)
    model.addConstr(12 * x2 + 13 * x3 <= 119)
    model.addConstr(26 * x0 + 13 * x3 <= 108)
    model.addConstr(9 * x0 + 26 * x1 + 19 * x3 <= 168)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Bill: ", x1.varValue)
        print("Hours worked by Hank: ", x2.varValue)
        print("Hours worked by Paul: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
