
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="mechanical_pencils")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="headsets")


    # Set objective function
    model.setObjective(1.36 * x0 + 8.25 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * x0 + 8 * x1 >= 44, "employee_satisfaction_min")
    model.addConstr(5 * x0 + 8 * x1 >= 11, "usefulness_min")
    model.addConstr(2 * x0 + 2 * x1 >= 39, "storage_min")
    model.addConstr(3 * x0 - 3 * x1 >= 0, "x0_x1_relation")
    model.addConstr(9 * x0 + 8 * x1 <= 48, "employee_satisfaction_max")
    model.addConstr(5 * x0 + 8 * x1 <= 25, "usefulness_max")
    model.addConstr(2 * x0 + 2 * x1 <= 71, "storage_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Mechanical Pencils: {x0.x}")
        print(f"Headsets: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check variable definitions.")

