
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="mechanical_pencils")
x1 = m.addVar(vtype=GRB.INTEGER, name="headsets")

# Objective function: Minimize 1.36*x0 + 8.25*x1
m.setObjective(1.36*x0 + 8.25*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(9*x0 + 8*x1 >= 44, name="min_employee_satisfaction")
m.addConstr(9*x0 + 8*x1 <= 48, name="max_employee_satisfaction")
m.addConstr(5*x0 + 8*x1 >= 11, name="min_usefulness_rating")
m.addConstr(5*x0 + 8*x1 <= 25, name="max_usefulness_rating")
m.addConstr(2*x0 + 2*x1 >= 39, name="min_storage_space")
m.addConstr(2*x0 + 2*x1 <= 71, name="max_storage_space")
m.addConstr(3*x0 - 3*x1 >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mechanical Pencils: {x0.x}")
    print(f"Headsets: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
