
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="mechanical_pencils", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="headsets", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(1.36 * x0 + 8.25 * x1, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(9 * x0 + 8 * x1 >= 44, name="employee_satisfaction_impact")
m.addConstr(5 * x0 + 8 * x1 >= 11, name="usefulness_rating")
m.addConstr(2 * x0 + 2 * x1 >= 39, name="storage_space")
m.addConstr(3 * x0 - 3 * x1 >= 0, name="balance_constraint")
m.addConstr(9 * x0 + 8 * x1 <= 48, name="max_employee_satisfaction_impact")
m.addConstr(5 * x0 + 8 * x1 <= 25, name="max_usefulness_rating")
m.addConstr(2 * x0 + 2 * x1 <= 71, name="max_storage_space")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Mechanical Pencils: ", x0.varValue)
    print("Headsets: ", x1.varValue)
else:
    print("The model is infeasible")
